<?php
    /**
    *
    * copyright (c) 2013-2024 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    *
    * Classe per gestire le comunicazioni in Geecom
    */

    class Comunicazione {
        
        private $db;
        private $id;
        private $idUtente;
	private $tipo;
	private $stato;
	private $priorita;
        private $template;
	private $oggetto;
	private $testo;
	private $autore;
        private $inviaMail;
        private $inviaNotifica;
        private $mailInviate;
        private $efficacia;
        private $mailNonInviate;
        private $logInvio;
        private $dataCreazione;
        private $dataInvio;
                
        function __construct($db, $id, $idUtente = 0, $tipo = "", $stato = "", $priorita = "", $template = "", $oggetto = "", $testo = "", $autore = "", $inviaMail = "", $inviaNotifica = "", $efficacia = "", $dataCreazione = null, $dataInvio = null) {
            $this->db = $db;
            $this->id = $id;
            $this->idUtente = $idUtente;
            $this->tipo     = $tipo;
            $this->stato    = $stato;
            $this->priorita = $priorita;
            $this->template = $template;
            $this->oggetto  = $oggetto;
            $this->testo    = $testo;
            $this->autore   = $autore;
            $this->inviaMail      = $inviaMail;
            $this->inviaNotifica  = $inviaNotifica;
            $this->mailInviate    = 0;
            $this->mailNonInviate = 0;
            $this->efficacia      = $efficacia;
            $this->logInvio       = "";
            $this->dataCreazione  = $dataCreazione;
            $this->dataInvio      = $dataInvio;
        }

        function crea() {
            $data  = date("Y-m-d H:i");
            $query = "INSERT INTO `geecAd_comunicazioni` (`id`, `idUtente`, `tipo`, `stato`, `priorita`, `template`, `oggetto`, `testo`, `autore`, `inviaEmail`, `inviaNotifica`, `mailInviate`, `mailNonInviate`, `efficacia`, `logInvio`, `dataCreazione`, `dataInvio`) "
                    . "VALUES (NULL, $this->idUtente, '$this->tipo', '$this->stato', '$this->priorita', '$this->template', '$this->oggetto', '$this->testo', '$this->autore', '$this->inviaMail', '$this->inviaNotifica', '$this->mailInviate', '$this->mailNonInviate', '$this->efficacia', '$this->logInvio','$data','$data')";
            $this->id = $this->db->eseguiQueryCreazione($query);
            return $this->id;
        }
        
        function modifica() {
            $query = "UPDATE `geecAd_comunicazioni` SET tipo='$this->tipo', stato='$this->stato', priorita='$this->priorita', template='$this->template', oggetto='$this->oggetto', testo='$this->testo', inviaNotifica='$this->inviaNotifica', inviaEmail='$this->inviaMail', efficacia='$this->efficacia' WHERE id=$this->id ";
            $this->db->eseguiQueryCreazione($query);
        }
        
        function elimina() {
            $this->db->eseguiQueryCancellazione("geecAd_comunicazioni",$this->id);
        }
        
        function duplica($prefisso = "Copia di") {
            $comunicazioneDaCopiare = $this->db->leggiSingolaRiga("geecAd_comunicazioni",$this->id);
            $this->db->eseguiQueryScrittura("CREATE TEMPORARY TABLE tabella_temporanea SELECT * FROM geecAd_comunicazioni WHERE id={$this->id}");
            $this->db->eseguiQueryScrittura("UPDATE tabella_temporanea SET id = 0;");
            $this->db->eseguiQueryScrittura("INSERT INTO geecAd_comunicazioni SELECT * FROM tabella_temporanea;");
            $idComunicazioneDuplicata = $this->db->idUltimoElemento();
                
            $this->db->eseguiQueryScrittura("UPDATE geecAd_comunicazioni SET stato='', oggetto='$prefisso {$comunicazioneDaCopiare["oggetto"]}', mailInviate = 0, mailNonInviate=0, logInvio='', dataCreazione='".date("Y-m-d")."', dataCreazione = '".date("Y-m-d H:i")."' WHERE id=$idComunicazioneDuplicata");
            
            $queryAssociazioniComunicazioneGruppo = "SELECT * FROM geecAd_gruppiDestinatari WHERE idComunicazione = {$this->id}";
            $risComunicazioni = $this->db->eseguiQueryLettura($queryAssociazioniComunicazioneGruppo);
                
            while($associazione = $risComunicazioni->fetch_assoc()) {
                $queryInserimentoGruppi="INSERT INTO geecAd_gruppiDestinatari VALUES(NULL,{$idComunicazioneDuplicata},0,{$associazione["idGruppoDestinatario"]})";
                $this->db->eseguiQueryScrittura($queryInserimentoGruppi);
            }
            
            return $idComunicazioneDuplicata;
        }
        
        function aggiungiRispostaTicket($testo,$nomeUtente) {
            $dataCreazione = date("Y-m-d H:i");
            $query = "INSERT INTO geecAd_risposteTicket VALUES(NULL,$this->id,'$testo','$nomeUtente','$dataCreazione');";
            return $this->db->eseguiQueryCreazione($query);
        }
        
        function aggiungiAllegato($percorso) {
            $query = "INSERT INTO geecAd_allegatiComunicazioni VALUES(NULL,$this->id,'$percorso');";
            return $this->db->eseguiQueryCreazione($query);
        }
        
        function cambiaStato($stato) {
            $query = "UPDATE geecAd_comunicazioni SET stato='$stato' WHERE id=$this->id";
            return $this->db->eseguiQueryCreazione($query);
        }
        
        function caricaDatiDalDatabase() {
            $datiComunicazione = $this->db->leggiSingolaRiga("geecAd_comunicazioni",$this->id);
            $this->tipo     = $datiComunicazione["tipo"];
            $this->idUtente = $datiComunicazione["idUtente"];
            $this->priorita = $datiComunicazione["priorita"];
            $this->template = $datiComunicazione["template"];
            $this->oggetto  = $datiComunicazione["oggetto"];
            $this->testo    = $datiComunicazione["testo"];
            $this->stato    = $datiComunicazione["stato"];
            $this->inviaMail      = $datiComunicazione["inviaEmail"];
            $this->inviaNotifica  = $datiComunicazione["inviaNotifica"];
            $this->mailInviate    = $datiComunicazione["mailInviate"];
            $this->mailNonInviate = $datiComunicazione["mailNonInviate"];
            $this->logInvio       = $datiComunicazione["logInvio"];
            $this->dataCreazione  = $datiComunicazione["dataCreazione"];
            $this->dataInvio      = $datiComunicazione["dataInvio"];
        }
        
        function stampaComponenti($stampaComponenti = true) {
            $query = "SELECT c.*, cm.nome, cm.icona FROM geecAd_composizioneComunicazioni AS c JOIN geecAd_componenti AS cm ON c.idComponente=cm.id WHERE idComunicazione=$this->id ORDER BY posizione ASC";
            $ris   = $this->db->eseguiQueryLettura($query);
            
            if($ris->num_rows>0) {
                while($componente = $ris->fetch_assoc()) {
                    $posizionePrecedente = $componente["posizione"]-1;
                    $posizioneSuccessiva = $componente["posizione"]+1;

                    ?>
                    <div id="componenteComunicazione<?= $componente["id"] ?>" class="card mb-3">
                        <div class="card-header py-1 pr-sm-1 d-sm-flex justify-content-between align-items-center text-center">
                            <div class="mb-1 mb-sm-0 d-flex align-items-center justify-content-start">

                            </div>
                            <div class="azioni d-flex align-items-center justify-content-end">
                                <?php 
                                    if($stampaComponenti) {
                                ?>                                    
                                <form class="d-inline-flex mr-sm-1">
                                    <div class="input-group input-group-sm d-flex align-items-center">
                                        <small class="text-muted mr-2">Pos.</small>
                                        <input type="number" class="form-control" aria-label="posizione" min="1" value="<?= $componente["posizione"] ?>" id="posizioneComponente<?= $componente["id"] ?>">
                                        <div class="input-group-append">
                                            <button class="btn btn-primary" type="button" onclick="modificaPosizioneComponenteDaInput(<?= $componente["id"] ?>)">Salva</button>
                                        </div>
                                    </div>
                                </form>
                                <div class="btn-group" role="group" aria-label="Basic example">
                                    <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" title="Sposta su" onclick="{modificaPosizioneComponente(<?= $componente["id"]  ?>,<?= $posizionePrecedente ?>)}"><i class="fas fa-arrow-up" ></i></button>
                                    <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" title="Sposta giu" onclick="{modificaPosizioneComponente(<?= $componente["id"] ?>,<?= $posizioneSuccessiva ?>)}"><i class="fas fa-arrow-down"></i></button>
                                    <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" title="Duplica" onclick="duplicaComponente(<?= $componente["id"] ?>)"><i class="far fa-clone"></i></button>
                                    <button type="button" class="btn btn-light elimina" data-toggle="tooltip" data-placement="bottom" title="Elimina" onclick="eliminaComponente(<?= $componente["id"] ?>,'<?= $componente["icona"] ?>','<?= $componente["nome"] ?>')" ><i class="far fa-trash-alt"></i></button>
                                </div>
                                <?php
                                    }
                                ?>
                           </div>
                        </div>
                        <div class= "card-body py-lg-0 d-flex align-items-center">
                            <img class="thumb d-none d-lg-block" src="<?= $componente["icona"] ?>">
                            <div class="input-group mr-3">
                                <span class="mr-3 align-self-center text-primary"><em><?= $componente["nome"] ?></em></span>
                                <?php 
                                    $datiGeecomCms = $this->db->leggiSingolaRiga("geec_prodotti",1);
                                    if($componente["nome"]=="Articolo dal blog") {
                                        if($datiGeecomCms["installato"]=="si") {
                                            $idElemento = ($componente["testo"]=="") ? 0 : $componente["testo"];
                                            $queryElementiComponente = "SELECT * FROM geecB_contenuti WHERE tipo LIKE 'articolo' OR id=$idElemento LIMIT 100";
                                            $risElementoComponente   = $this->db->eseguiQueryLettura($queryElementiComponente);
                                            echo"<select class=\"form-control form-control-sm\" id=\"idElementoComponente{$componente["id"]}\">";
                                                    while($elemento = $risElementoComponente->fetch_assoc()) {
                                                        if($componente["testo"]==$elemento["id"]) {
                                                            echo"<option value=\"{$elemento["id"]}\" selected >{$elemento["titolo"]}</option>";
                                                        }
                                                        else {
                                                            echo"<option value=\"{$elemento["id"]}\">{$elemento["titolo"]}</option>";
                                                        }
                                                    }
                                            echo"</select>
                                            <div class=\"input-group-append\">
                                                <button type=\"button\" class=\"btn btn-primary btn-sm\" onclick=\"cambiaIdElemento({$componente["id"]})\">Salva</button>
                                            </div>";
                                        }
                                        else {
                                            ?>
                                            <div class="alert alert-warning mt-3">Geecom CMS non è installato</div>
                                            <?php
                                        }
                                    }
                                    else if($componente["nome"]=="Prodotto dal negozio") {
                                        $datiComponenteEcommerce = ($datiGeecomCms["installato"]=="si") ? $this->db->leggiSingolaRiga("geecB_componenti","Ecommerce","nome") : null;
                                        
                                        if($datiGeecomCms["installato"]=="si" && isset($datiComponenteEcommerce["versione"])) {
                                            $queryElementiComponente = "SELECT * FROM geecEc_prodotti ORDER BY id DESC LIMIT 250";
                                            $risElementoComponente   = $this->db->eseguiQueryLettura($queryElementiComponente);
                                            echo"<select class=\"form-control form-control-sm\" id=\"idElementoComponente{$componente["id"]}\">";
                                                    while($elemento = $risElementoComponente->fetch_assoc()) {
                                                        if($componente["testo"]==$elemento["id"]) {
                                                            echo"<option value=\"{$elemento["id"]}\" selected >{$elemento["titolo"]}</option>";
                                                        }
                                                        else {
                                                            echo"<option value=\"{$elemento["id"]}\">{$elemento["titolo"]}</option>";
                                                        }
                                                    }
                                            echo"</select>
                                            <div class=\"input-group-append\">
                                                <button type=\"button\" class=\"btn btn-primary btn-sm\" onclick=\"cambiaIdElemento({$componente["id"]})\">Salva</button>
                                            </div>";
                                        }
                                        else if($datiGeecomCms["installato"]=="si") {
                                            ?>
                                            <div class="alert alert-warning mt-3">Il componente e-commerce di Geecom CMS non è installato</div>
                                            <?php
                                        }
                                        else {
                                            ?>
                                            <div class="alert alert-warning mt-3">Geecom CMS non è installato</div>
                                            <?php
                                        }
                                    }
                                    else {
                                        ?><span class="text-truncate text-muted d-block w-75"><?= substr(strip_tags($componente["testo"]),0,90) ?></span><?php
                                    }
                                ?>
                            </div>

                            <?php
                                if($stampaComponenti && $componente["nome"]!="Articolo dal blog" && $componente["nome"]!="Prodotto dal negozio") {
                                    echo"<div class=\"btn-group\">
                                            <button type=\"button\" class=\"btn btn-primary btn-sm text-nowrap\" data-toggle=\"modal\" data-target=\"#configuraComponente{$componente["id"]}\"><span class=\"d-none d-lg-inline-block\">Configura</span><i class=\"far fa-edit fa-fw ml-1\"></i></button>
                                        </div>";
                                }
                                
                            ?>
                        </div>
                    </div>
                    <?php
                }
            }
            else {
            	?>
            	<div class="col-12 bg-light text-center mb-3">
		    <div class="card-body">
			Questa comunicazione non ha componenti
		    </div>
		</div>
            	<?php
            }
        }
                
        public function modificaPosizioneComponente($idComponente,$posizione) {

            $queryPosizione = "SELECT * FROM geecAd_composizioneComunicazioni WHERE idComunicazione=$this->id AND id != $idComponente ORDER BY posizione ASC";
            $risElementi    = $this->db->eseguiQueryLettura($queryPosizione);
            
            $posizioneCorrente = 1;
            while($elementoCorrente = $risElementi->fetch_assoc()) {
                if($posizione==$posizioneCorrente) {
                    $posizioneCorrente++;
                }
                $queryPosizione = "UPDATE geecAd_composizioneComunicazioni SET posizione=$posizioneCorrente WHERE id = {$elementoCorrente["id"]} ";
                $this->db->eseguiQueryScrittura($queryPosizione);
                $posizioneCorrente ++;
            }
            $queryPosizioneElementoPrincipale = "UPDATE geecAd_composizioneComunicazioni SET posizione=$posizione WHERE id = $idComponente ";
            $this->db->eseguiQueryScrittura($queryPosizioneElementoPrincipale);
        }
        
        public function generaCodice() {
            $impostazioni = $this->db->leggiSingolaRiga("geecAd_impostazioni",1);
            $datiTemplate = $this->db->leggiSingolaRiga("geec_templateEmail",$this->template);
            $query = "SELECT c.*, cm.nome, cm.icona FROM geecAd_composizioneComunicazioni AS c JOIN geecAd_componenti AS cm ON c.idComponente=cm.id WHERE idComunicazione=$this->id ORDER BY posizione ASC";
            $ris   = $this->db->eseguiQueryLettura($query);
            
            $codiceCorpoMail = "";
	    while($componente = $ris->fetch_assoc()) {
		$arrayOpzioni = explode(";",$componente["altreOpzioni"]);
	    	if($componente["nome"]=="Immagine") {
                    $codiceCorpoMail .= "<tr>
                            <td>
                                <img src=\"{$impostazioni["urlPiattaforma"]}/{$componente["testo"]}\">
                            </td>
                        </tr>";
	    	}
	    	else if($componente["nome"]=="Intestazione") {
                    if(count($arrayOpzioni)>1) {                        
                        $arrayIntestazioneScelta = explode("=",$arrayOpzioni[0]);
                        $intestazioneScelta = str_replace(";","",$arrayIntestazioneScelta[1]);

                        // codice valido solo fino a quando il c'è un campo
                        $arrayOpzioneAllineamento = explode("=",$arrayOpzioni[1]);
                        $opzioneAllineamento = str_replace(";","",$arrayOpzioneAllineamento[1]);

                        // codice valido solo fino a quando il c'è un campo
                        $arrayOpzioneColore = explode("=",$arrayOpzioni[2]);
                        $opzioneColore      = str_replace(";","",$arrayOpzioneColore[1]);
                        $stringaStile       = ($opzioneColore!="") ? "style=\"color:$opzioneColore;\"" : "";
                    }
                    else {
                        $stringaStile = "";
                    }
                    
                    $codiceCorpoMail .= "<tr>
                        <td>
                            <h1 $stringaStile>{$componente["testo"]}</h1>
                        </td>
                    </tr>";
	    	}
	    	else if($componente["nome"]=="Testo" || $componente["nome"]=="HTML") {
                    $codiceCorpoMail .= "<tr>
                        <td>
                            {$componente["testo"]}
                        </td>
                    </tr>";
	    	}
	    	else if($componente["nome"]=="Pulsante") {
                    $arrayLink = explode("=",$arrayOpzioni[0]);
                    if(isset($arrayLink[1])) {                    
                        $link = str_replace(";","",$arrayLink[1]);
                    }
                    else {
                        $link = "";
                    }

                    // codice valido solo fino a quando il c'è un campo
                    if(isset($arrayOpzioni[1])) {
                        $arrayOpzioneColore = explode("=",$arrayOpzioni[1]);
                        $opzioneColore      = str_replace(";","",$arrayOpzioneColore[1]);
                        $stringaStile       = ($opzioneColore!="") ? "style=\"background:$opzioneColore;\"" : "";
                    }
                    else {
                        $stringaStile = "";
                    }
                    
                    $codiceCorpoMail .= "<tr>
                        <td align=\"center\" class=\"btn btn-primary\">
                                <a href=\"$link\" $stringaStile>{$componente["testo"]}</a>
                        </td>
                    </tr>";
	    	}
                else if($componente["nome"]=="Articolo dal blog") {
                    $datiGeecomCms = $this->db->leggiSingolaRiga("geec_prodotti",1);
                    if($datiGeecomCms["installato"]=="si" && is_numeric($componente["testo"])) {
                        $impostazioni  = $this->db->leggiSingolaRiga("geecB_impostazioni",1);                    
                        $datiArticolo  = $this->db->leggiSingolaRiga("geecB_contenuti",$componente["testo"]); 
                        $testoArticolo = substr( $datiArticolo["testo"] , 0, 300);
                        $linkArticolo  = GeneratoreUrl::creaUrlContenuto($datiArticolo, $impostazioni["ottimizzazioneUrl"], $impostazioni["urlSito"]);
                        $codiceCorpoMail .= "<tr>
                                    <td align=\"left\">
                                        <h2>{$datiArticolo["titolo"]}</h2>
                                        <a href=\"$linkArticolo\"><img src=\"{$impostazioni["urlSito"]}/{$datiArticolo["foto"]}\" alt=\"{$datiArticolo["titolo"]}\" width=\"516\" height=\"346\" border=\"0\" style=\"border:0; outline:none; text-decoration:none; display:block;\"></a>
                                        <p>  $testoArticolo <a href=\"$linkArticolo\"><strong>Segue...</strong></a></p>
                                    </td>
                                </tr>";
                    }
                }
                else if($componente["nome"]=="Prodotto dal negozio") {
                    $datiGeecomCms = $this->db->leggiSingolaRiga("geec_prodotti",1);
                    if($datiGeecomCms["installato"]=="si") {
                        $impostazioni  = $this->db->leggiSingolaRiga("geecB_impostazioni",1);
                        $datiProdotto  = $this->db->leggiSingolaRiga("geecEc_prodotti",$componente["testo"]); 
                        $testoProdotto = substr( $datiProdotto["testo"] , 0, 1000);
                        $codiceCorpoMail .= "<tr>
                                    <td align=\"left\">
                                        <a href=\"{$impostazioni["urlSito"]}/prodotto.php?alias={$datiProdotto["alias"]}\"><img src=\"{$impostazioni["urlSito"]}/{$datiProdotto["foto"]}\" alt=\"{$datiArticolo["titolo"]}\" width=\"516\" height=\"346\" border=\"0\" style=\"border:0; outline:none; text-decoration:none; display:block;\"></a>
                                        <h2>{$datiProdotto["nome"]}</h2>
                                        <p> $testoProdotto <a href=\"{$impostazioni["urlSito"]}/prodotto.php?alias={$datiProdotto["alias"]}\"><strong>Segue...</strong></a></p>
                                    </td>
                                </tr>";
                    }
                }
	    }
	    
	    $codiceEmail = "<!doctype html>
                    <html>
                      <head>
                        <meta name=\"viewport\" content=\"width=device-width\" />
                        <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />
                        <title>$this->oggetto</title>
                        <style>
                            {$datiTemplate['css']}
                        </style>
                      </head>
                      <body class=\"\">".
                    str_replace("testo_da_inserire", $codiceCorpoMail,$datiTemplate["corpoMail"]).$datiTemplate["footerMail"].
                    "</body>
                    </html>";
	    return $codiceEmail;
        }
        
        /*
         * funzione che esegue l'analisi dei dati inseriti e da dei consigli
         */
        function eseguiAnalisi() {
            //variabili che memorizzano l'indicatore per la seo
            $efficaciaBuona    = "<span class=\"badge badge-success p-2\">BUONA</span>";
            $efficaciaDiscreta = "<span class=\"badge badge-warning p-2\">DISCRETA</span>";
            $efficaciaBassa    = "<span class=\"badge badge-danger p-2\">BASSA</span>";
            
            $efficaciaBuonaTesto     = "buona";
            $efficaciaDiscretaTesto  = "discreta";
            $efficaciaBassaTesto     = "bassa";
            
            //inizializzazione array che contiene i risultati
            $analisi             = array();
            $suggerimenti        = array();
            $analisi["esito"] = $efficaciaBassa;
            $analisi["esitoTesto"] = $efficaciaBassaTesto;
            $suggerimenti       = array();
            $punteggioEfficacia = 0;
            
            //analisi oggetto
            $numeroCaratteriOggetto = strlen($this->oggetto);
            if ($numeroCaratteriOggetto > 20 && $numeroCaratteriOggetto < 50) {
                $punteggioEfficacia += 1;
            }
            
            //analisi testo
            $numeroCaratteriDescrizione = $this->contaTestoComunicazione();
            if($numeroCaratteriDescrizione==0) {
                $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> Il <strong>testo</strong> è assente, inviare una mail senza testo è un errore.</p>";
                $punteggioEfficacia -= 1;
            }
            else if ($numeroCaratteriDescrizione > 0 && $numeroCaratteriDescrizione <= 60) { // con questa quantità di testo non si ottengono punti in piu
                $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> Il <strong>testo</strong> è troppo corto, solo $numeroCaratteriDescrizione caratteri. Scrivi almeno 250 caratteri.</p>";
            }
            else if ($numeroCaratteriDescrizione > 60 && $numeroCaratteriDescrizione <= 250) {
                $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> Il <strong>testo</strong> è troppo corto, solo $numeroCaratteriDescrizione caratteri. Scrivi almeno 250 caratteri.</p>";
                $punteggioEfficacia += 1;
            }
            else if($numeroCaratteriDescrizione > 250) {
                $punteggioEfficacia += 2;
            }

            // analisi immagini
            $numeroImmagini = $this->contaImmaginiComunicazione();
            if($numeroImmagini==0) {
                $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> Non ci sono <strong>immagini</strong>, inseriscine almeno una</p>";
                $punteggioEfficacia -= 1;
            }
            else {
                $punteggioEfficacia += 1;
            }

            // analisi inviti all'azione
            $numeroInvitiAzione = $this->contaInvitiAzione();
            if($numeroInvitiAzione==0) {
                $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> Non ci sono <strong>inviti all'azione</strong>, inserisci almeno un pulsante</p>";
                $punteggioEfficacia -= 2;
            }

            if($punteggioEfficacia > 2) {
                $analisi["esito"]      = $efficaciaBuona;
                $analisi["esitoTesto"] = $efficaciaBuonaTesto;
            }
            else if($punteggioEfficacia == 2) {
                $analisi["esito"]      = $efficaciaDiscreta;
                $analisi["esitoTesto"] = $efficaciaDiscretaTesto;
            }
            $analisi["suggerimenti"] = $suggerimenti;
            return $analisi;
        }
        
        /*
         * Questa funzione controlla il testo della comunicazione, contando i caratteri della colonan testo e 
         * di ogni componente testo
         */
        function contaTestoComunicazione() {
            $numeroCaratteriTesto = strlen($this->testo);
            $queryComponenteTesto = "SELECT * FROM geecAd_composizioneComunicazioni WHERE (idComponente=19 OR idComponente=20) AND idComunicazione = $this->id";
            $risComponentiTesto   = $this->db->eseguiQueryLettura($queryComponenteTesto);
            while($componenteTesto = $risComponentiTesto->fetch_assoc()) {
                    $numeroCaratteriTesto += strlen(strip_tags($componenteTesto["testo"]));
            }
            return $numeroCaratteriTesto;
        }

        function contaImmaginiComunicazione() {
            $queryComponenteUnnagini = "SELECT * FROM geecAd_composizioneComunicazioni WHERE idComponente=21 AND idComunicazione = $this->id";
            $risComponentiImmagini   = $this->db->eseguiQueryLettura($queryComponenteUnnagini);
            return $risComponentiImmagini->num_rows;
        }
                
        function contaInvitiAzione() {
            $queryComponentePulsante = "SELECT * FROM geecAd_composizioneComunicazioni WHERE idComponente=22 AND idComunicazione = $this->id";
            $risComponentiPulsanti   = $this->db->eseguiQueryLettura($queryComponentePulsante);
            return $risComponentiPulsanti->num_rows;
        }
        
        // Getter & setter
        function getId() {
            return $this->id;
        }

        function getIdUtente() {
            return $this->idUtente;
        }

        function getTipo() {
            return $this->tipo;
        }

        function getStato() {
            return $this->stato;
        }

        function getPriorita() {
            return $this->priorita;
        }

        function getOggetto() {
            return $this->oggetto;
        }

        function getTesto() {
            return $this->testo;
        }

        function getAutore() {
            return $this->autore;
        }

        function getDataCreazione() {
            return $this->dataCreazione;
        }
       
        public function getDataInvio() {
            return $this->dataInvio;
        }
        
        function getTemplate() {
            return $this->template;
        }

        function getMailInviate() {
            return $this->mailInviate;
        }

        function getMailNonInviate() {
            return $this->mailNonInviate;
        }

        public function getEfficacia() {
            return $this->efficacia;
        }

        function getLogInvio() {
            return $this->logInvio;
        }
        
        function getInviaMail() {
            return $this->inviaMail;
        }

        function getInviaNotifica() {
            return $this->inviaNotifica;
        }

        function setId($id) {
            $this->id = $id;
        }

        function setIdUtente($idUtente) {
            $this->idUtente = $idUtente;
        }

        function setTipo($tipo) {
            $this->tipo = $tipo;
        }

        function setStato($stato) {
            $this->stato = $stato;
        }

        function setPriorita($priorita) {
            $this->priorita = $priorita;
        }

        function setOggetto($oggetto) {
            $this->oggetto = $oggetto;
        }

        function setTesto($testo) {
            $this->testo = $testo;
        }

        function setAutore($autore) {
            $this->autore = $autore;
        }

        function setDataCreazione($dataCreazione) {
            $this->dataCreazione = $dataCreazione;
        }

        public function setDataInvio($dataInvio): void {
            $this->dataInvio = $dataInvio;
        }

        function setTemplate($template) {
            $this->template = $template;
        }
        
        function setMailInviate($mailInviate){
            $this->mailInviate = $mailInviate;
        }

        function setMailNonInviate($mailNonInviate){
            $this->mailNonInviate = $mailNonInviate;
        }

        public function setEfficacia($efficacia) {
            $this->efficacia = $efficacia;
        }
        
        function setLogInvio($logInvio){
            $this->logInvio = $logInvio;
        }
        
        function setInviaMail($inviaMail) {
            $this->inviaMail = $inviaMail;
        }

        function setInviaNotifica($inviaNotifica) {
            $this->inviaNotifica = $inviaNotifica;
        }
    }
